/*
 * Decompiled with CFR 0.152.
 */
package com.iss.nuxeo.bulkimport.factories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.NuxeoPrincipal;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.api.local.ClientLoginModule;
import org.nuxeo.ecm.core.schema.DocumentType;
import org.nuxeo.ecm.core.schema.SchemaManager;
import org.nuxeo.ecm.platform.importer.factories.DefaultDocumentModelFactory;
import org.nuxeo.ecm.platform.importer.source.SourceNode;
import org.nuxeo.runtime.api.Framework;

public class HeuristicDocumentModelFactory
extends DefaultDocumentModelFactory {
    private static final Log log = LogFactory.getLog(HeuristicDocumentModelFactory.class);
    protected static final String DEFAULT_FOLDERISH_DOCTYPE = "Folder";
    protected static final String DEFAULT_LEAF_DOCTYPE = "File";
    public static final String ISS_BULK_IMPORT_FOLDER_DOC_TYPE = "iss.bulk.import.folder.type";
    public static final String ISS_BULK_IMPORT_LEAF_DOC_TYPE = "iss.bulk.import.leaf.type";

    public HeuristicDocumentModelFactory() {
        this(DEFAULT_FOLDERISH_DOCTYPE, DEFAULT_LEAF_DOCTYPE);
    }

    public HeuristicDocumentModelFactory(String folderishType, String leafType) {
        super(folderishType, leafType);
    }

    public DocumentModel createFolderishNode(CoreSession session, DocumentModel parent, SourceNode node) throws IOException {
        String name = this.getValidNameFromFileName(node.getName());
        BlobHolder bh = node.getBlobHolder();
        String folderishTypeToUse = this.deduceFolderDocType(parent, bh);
        List facets = this.getFacetsToUse(bh);
        DocumentModel doc = session.createDocumentModel(parent.getPathAsString(), name, folderishTypeToUse);
        for (String facet : facets) {
            doc.addFacet(facet);
        }
        this.enrichMetadata(doc, session);
        doc = session.createDocument(doc);
        if (bh != null) {
            doc = this.setDocumentProperties(session, bh.getProperties(), doc);
        }
        return doc;
    }

    public String deduceFolderDocType(DocumentModel parent, BlobHolder bh) throws IOException {
        String docType = this.getDocTypeToUse(bh);
        if (!StringUtils.isBlank((CharSequence)docType)) {
            return docType;
        }
        SchemaManager schema = (SchemaManager)Framework.getService(SchemaManager.class);
        DocumentType dt = schema.getDocumentType(parent.getType());
        Set dtc = dt.getAllowedSubtypes();
        List dtl = dtc.stream().map(arg_0 -> ((SchemaManager)schema).getDocumentType(arg_0)).filter(s -> s.isFolder() && !s.isFile()).map(d -> d.getName()).collect(Collectors.toCollection(ArrayList::new));
        String preferredFolderDocType = Framework.getProperty((String)ISS_BULK_IMPORT_FOLDER_DOC_TYPE);
        if (StringUtils.isBlank((CharSequence)preferredFolderDocType)) {
            String string = preferredFolderDocType = StringUtils.isBlank((CharSequence)this.folderishType) ? DEFAULT_FOLDERISH_DOCTYPE : this.folderishType;
        }
        if (dtl.isEmpty()) {
            log.warn((Object)String.format("use default doctype %1$s, there is no allowed folderish child types under %2$s, ", preferredFolderDocType, dt.getName()));
            return preferredFolderDocType;
        }
        if (dtl.contains(preferredFolderDocType)) {
            log.info((Object)String.format("use configured doctype %1$s which is an allowed folderish child types under %2$s.", preferredFolderDocType, dt.getName()));
            return preferredFolderDocType;
        }
        log.info((Object)String.format("pick up %1$s as the folderish doctype from %2$s's allowed folderish child types %3$s.", dtl.get(0), dt.getName(), dtl));
        return (String)dtl.get(0);
    }

    public DocumentModel defaultCreateLeafNode(CoreSession session, DocumentModel parent, SourceNode node) throws IOException {
        Blob blob = null;
        Map props = null;
        BlobHolder bh = node.getBlobHolder();
        String leafTypeToUse = "";
        if (bh != null) {
            blob = bh.getBlob();
            props = bh.getProperties();
            String bhType = this.getDocTypeToUse(bh);
            if (bhType != null) {
                leafTypeToUse = bhType;
            }
        }
        if (StringUtils.isBlank((CharSequence)leafTypeToUse)) {
            leafTypeToUse = this.deduceLeafDocType(parent);
        }
        String fileName = node.getName();
        String name = this.getValidNameFromFileName(fileName);
        DocumentModel doc = session.createDocumentModel(parent.getPathAsString(), name, leafTypeToUse);
        for (String facet : this.getFacetsToUse(bh)) {
            doc.addFacet(facet);
        }
        doc.setProperty("dublincore", "title", (Object)node.getName());
        if (blob != null && blob.getLength() > 0L) {
            blob.setFilename(fileName);
            doc.setProperty("file", "content", (Object)blob);
        }
        doc = session.createDocument(doc);
        if (props != null) {
            doc = this.setDocumentProperties(session, props, doc);
        }
        return doc;
    }

    public String deduceLeafDocType(DocumentModel parent) {
        SchemaManager schema = (SchemaManager)Framework.getService(SchemaManager.class);
        DocumentType dt = schema.getDocumentType(parent.getType());
        Set dtc = dt.getAllowedSubtypes();
        List dtl = dtc.stream().map(arg_0 -> ((SchemaManager)schema).getDocumentType(arg_0)).filter(s -> s.isFile()).map(d -> d.getName()).collect(Collectors.toCollection(ArrayList::new));
        String preferredFileDocType = Framework.getProperty((String)ISS_BULK_IMPORT_LEAF_DOC_TYPE);
        if (StringUtils.isBlank((CharSequence)preferredFileDocType)) {
            String string = preferredFileDocType = StringUtils.isBlank((CharSequence)this.leafType) ? DEFAULT_LEAF_DOCTYPE : this.leafType;
        }
        if (dtl.isEmpty()) {
            log.warn((Object)String.format("use default doctype %1$s, there is no allowed file child types under %2$s, ", preferredFileDocType, dt.getName()));
            return preferredFileDocType;
        }
        if (dtl.contains(preferredFileDocType)) {
            log.info((Object)String.format("use configured doctype %1$s which is an allowed file child types under %2$s.", preferredFileDocType, dt.getName()));
            return preferredFileDocType;
        }
        log.info((Object)String.format("pick up %1$s as the file doctype from %2$s's allowed file child types %3$s.", dtl.get(0), dt.getName(), dtl));
        return (String)dtl.get(0);
    }

    public void enrichMetadata(DocumentModel doc, CoreSession session) {
        doc.setProperty("dublincore", "title", (Object)doc.getName());
        NuxeoPrincipal p = ClientLoginModule.getCurrentPrincipal();
        if (p != null) {
            doc.setProperty("dublincore", "creator", (Object)p.getName());
            doc.setProperty("dublincore", "lastContributor", (Object)p.getName());
            doc.setProperty("dublincore", "contributors", (Object)new String[]{p.getName()});
        }
    }
}

