/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.status;

import java.util.Map;
import org.nuxeo.ecm.core.blob.BlobManager;
import org.nuxeo.ecm.core.blob.BlobProvider;
import org.nuxeo.ecm.core.blob.binary.BinaryManager;
import org.nuxeo.ecm.core.management.api.Probe;
import org.nuxeo.ecm.core.management.api.ProbeStatus;
import org.nuxeo.ecm.core.storage.sql.S3BinaryManager;
import org.nuxeo.runtime.api.Framework;

public class S3BinaryManagerStatusProbe
implements Probe {
    public ProbeStatus run() {
        Map providers = ((BlobManager)Framework.getService(BlobManager.class)).getBlobProviders();
        boolean someSuccess = false;
        for (Map.Entry en : providers.entrySet()) {
            String id = (String)en.getKey();
            BlobProvider blobProvider = (BlobProvider)en.getValue();
            BinaryManager bm = blobProvider.getBinaryManager();
            if (bm == null || !(bm instanceof S3BinaryManager)) continue;
            if (!((S3BinaryManager)bm).canAccessBucket()) {
                return ProbeStatus.newFailure((String)("S3BinaryManager cannot access the configured bucket: " + id));
            }
            someSuccess = true;
        }
        if (someSuccess) {
            return ProbeStatus.newSuccess((String)"S3BinaryManager can access the configured buckets");
        }
        return ProbeStatus.newFailure((String)"No S3BinaryManager bucket configured");
    }
}

