/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.ObjectMetadata;
import com.amazonaws.services.securitytoken.AWSSecurityTokenService;
import com.amazonaws.services.securitytoken.AWSSecurityTokenServiceClientBuilder;
import com.amazonaws.services.securitytoken.model.AssumeRoleRequest;
import com.amazonaws.services.securitytoken.model.Credentials;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.ecm.automation.server.jaxrs.batch.Batch;
import org.nuxeo.ecm.automation.server.jaxrs.batch.handler.AbstractBatchHandler;
import org.nuxeo.ecm.automation.server.jaxrs.batch.handler.BatchFileInfo;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.NuxeoException;
import org.nuxeo.ecm.core.blob.binary.Binary;
import org.nuxeo.ecm.core.blob.binary.BinaryBlob;
import org.nuxeo.ecm.core.blob.binary.LazyBinary;
import org.nuxeo.ecm.core.storage.sql.S3BinaryManager;
import org.nuxeo.ecm.core.storage.sql.S3Utils;
import org.nuxeo.runtime.aws.NuxeoAWSRegionProvider;

public class S3DirectBatchHandler
extends AbstractBatchHandler {
    private static final Log log = LogFactory.getLog(S3BinaryManager.class);
    protected static final Pattern REGEX_MULTIPART_ETAG = Pattern.compile("-\\d+$");
    protected static final Pattern REGEX_BUCKET_PATH_PLACE_HOLDER = Pattern.compile("\\{\\{bucketPath}}");
    public static final String ACCELERATE_MODE_ENABLED_PROPERTY = "accelerateMode";
    public static final String POLICY_TEMPLATE_PROPERTY = "policyTemplate";
    public static final String ROLE_ARN_PROPERTY = "roleArn";
    public static final String INFO_AWS_SECRET_KEY_ID = "awsSecretKeyId";
    public static final String INFO_AWS_SECRET_ACCESS_KEY = "awsSecretAccessKey";
    public static final String INFO_AWS_SESSION_TOKEN = "awsSessionToken";
    public static final String INFO_BUCKET = "bucket";
    public static final String INFO_BASE_KEY = "baseKey";
    public static final String INFO_EXPIRATION = "expiration";
    public static final String INFO_AWS_REGION = "region";
    public static final String INFO_USE_S3_ACCELERATE = "useS3Accelerate";
    protected AWSSecurityTokenService stsClient;
    protected AmazonS3 amazonS3;
    protected String region;
    protected String bucket;
    protected String bucketPrefix;
    protected boolean accelerateModeEnabled;
    protected int expiration;
    protected String policy;
    protected String roleArn;

    protected void initialize(Map<String, String> properties) {
        super.initialize(properties);
        this.region = properties.get(INFO_AWS_REGION);
        if (StringUtils.isBlank((CharSequence)this.region)) {
            this.region = NuxeoAWSRegionProvider.getInstance().getRegion();
        }
        this.bucket = properties.get(INFO_BUCKET);
        if (StringUtils.isBlank((CharSequence)this.bucket)) {
            throw new NuxeoException("Missing configuration property: bucket");
        }
        this.roleArn = properties.get(ROLE_ARN_PROPERTY);
        if (StringUtils.isBlank((CharSequence)this.roleArn)) {
            throw new NuxeoException("Missing configuration property: roleArn");
        }
        this.bucketPrefix = StringUtils.defaultString((String)properties.get("bucket_prefix"));
        this.accelerateModeEnabled = Boolean.parseBoolean(properties.get(ACCELERATE_MODE_ENABLED_PROPERTY));
        String awsSecretKeyId = properties.get("awsid");
        String awsSecretAccessKey = properties.get("awssecret");
        String awsSessionToken = properties.get("awstoken");
        this.expiration = Integer.parseInt((String)StringUtils.defaultIfEmpty((CharSequence)properties.get(INFO_EXPIRATION), (CharSequence)"0"));
        this.policy = properties.get(POLICY_TEMPLATE_PROPERTY);
        AWSCredentialsProvider credentials = S3Utils.getAWSCredentialsProvider(awsSecretKeyId, awsSecretAccessKey, awsSessionToken);
        this.stsClient = this.initializeSTSClient(credentials);
        this.amazonS3 = this.initializeS3Client(credentials);
        if (!StringUtils.isBlank((CharSequence)this.bucketPrefix) && !this.bucketPrefix.endsWith("/")) {
            log.warn((Object)String.format("%s %s S3 bucket prefix should end with '/': added automatically.", "bucket_prefix", this.bucketPrefix));
            this.bucketPrefix = this.bucketPrefix + "/";
        }
    }

    protected AWSSecurityTokenService initializeSTSClient(AWSCredentialsProvider credentials) {
        return (AWSSecurityTokenService)((AWSSecurityTokenServiceClientBuilder)((AWSSecurityTokenServiceClientBuilder)AWSSecurityTokenServiceClientBuilder.standard().withRegion(this.region)).withCredentials(credentials)).build();
    }

    protected AmazonS3 initializeS3Client(AWSCredentialsProvider credentials) {
        return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withRegion(this.region)).withCredentials(credentials)).withAccelerateModeEnabled(Boolean.valueOf(this.accelerateModeEnabled))).build();
    }

    public Batch getBatch(String batchId) {
        Map parameters = this.getBatchParameters(batchId);
        if (parameters == null) {
            return null;
        }
        Batch batch = new Batch(batchId, parameters, this.getName(), this.getTransientStore());
        AssumeRoleRequest request = new AssumeRoleRequest().withRoleArn(this.roleArn).withPolicy(this.policy).withRoleSessionName(batchId);
        if (this.expiration > 0) {
            request.setDurationSeconds(Integer.valueOf(this.expiration));
        }
        Credentials credentials = this.assumeRole(request);
        Map properties = batch.getProperties();
        properties.put(INFO_AWS_SECRET_KEY_ID, credentials.getAccessKeyId());
        properties.put(INFO_AWS_SECRET_ACCESS_KEY, credentials.getSecretAccessKey());
        properties.put(INFO_AWS_SESSION_TOKEN, credentials.getSessionToken());
        properties.put(INFO_BUCKET, this.bucket);
        properties.put(INFO_BASE_KEY, this.bucketPrefix);
        properties.put(INFO_EXPIRATION, credentials.getExpiration().toInstant().toEpochMilli());
        properties.put(INFO_AWS_REGION, this.region);
        properties.put(INFO_USE_S3_ACCELERATE, this.accelerateModeEnabled);
        return batch;
    }

    protected Credentials assumeRole(AssumeRoleRequest request) {
        return this.stsClient.assumeRole(request).getCredentials();
    }

    public boolean completeUpload(String batchId, String fileIndex, BatchFileInfo fileInfo) {
        ObjectMetadata newMetadata;
        String fileKey = fileInfo.getKey();
        ObjectMetadata metadata = this.amazonS3.getObjectMetadata(this.bucket, fileKey);
        String etag = metadata.getETag();
        if (StringUtils.isEmpty((CharSequence)etag)) {
            return false;
        }
        String newFileKey = this.bucketPrefix + etag;
        String mimeType = metadata.getContentType();
        String encoding = metadata.getContentEncoding();
        if (metadata.getContentLength() > this.lowerThresholdToUseMultipartCopy()) {
            newMetadata = S3Utils.copyFileMultipart(this.amazonS3, metadata, this.bucket, fileKey, this.bucket, newFileKey, true);
        } else {
            newMetadata = S3Utils.copyFile(this.amazonS3, metadata, this.bucket, fileKey, this.bucket, newFileKey, true);
            boolean isMultipartUpload = REGEX_MULTIPART_ETAG.matcher(etag).find();
            if (isMultipartUpload) {
                etag = newMetadata.getETag();
                String previousFileKey = newFileKey;
                newFileKey = this.bucketPrefix + etag;
                newMetadata = S3Utils.copyFile(this.amazonS3, metadata, this.bucket, previousFileKey, this.bucket, newFileKey, true);
            }
        }
        String filename = fileInfo.getFilename();
        long length = newMetadata.getContentLength();
        String digest = newMetadata.getContentMD5() != null ? newMetadata.getContentMD5() : etag;
        String blobProviderId = this.transientStoreName;
        LazyBinary binary = new LazyBinary(digest, blobProviderId, null);
        BinaryBlob blob = new BinaryBlob((Binary)binary, digest, filename, mimeType, encoding, digest, length);
        Batch batch = this.getBatch(batchId);
        batch.addFile(fileIndex, (Blob)blob, filename, mimeType);
        return true;
    }

    protected long lowerThresholdToUseMultipartCopy() {
        return 0x140000000L;
    }
}

