/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.core.storage.sql;

import com.amazonaws.AmazonClientException;
import com.amazonaws.auth.PEM;
import com.amazonaws.auth.RSA;
import com.amazonaws.services.cloudfront.CloudFrontUrlSigner;
import com.amazonaws.services.cloudfront.util.SignerUtils;
import com.amazonaws.util.IOUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.http.client.utils.URIBuilder;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.blob.ManagedBlob;
import org.nuxeo.ecm.core.storage.sql.S3BinaryManager;
import org.nuxeo.runtime.api.Framework;

public class CloudFrontBinaryManager
extends S3BinaryManager {
    private static final String BASE_PROP = "cloudfront.";
    public static final String PRIVATE_KEY_PROPERTY = "cloudfront.privKey";
    public static final String PRIVATE_KEY_ID_PROPERTY = "cloudfront.privKeyId";
    public static final String DISTRIB_DOMAIN_PROPERTY = "cloudfront.distribDomain";
    public static final String PROTOCOL_PROPERTY = "cloudfront.protocol";
    public static final String ENABLE_CF_ENCODING_FIX = "nuxeo.s3storage.cloudfront.fix.encoding";
    protected String distributionDomain;
    protected SignerUtils.Protocol protocol;
    protected PrivateKey privKey;
    protected String privKeyId;

    @Override
    protected void setupCloudClient() throws IOException {
        super.setupCloudClient();
        this.protocol = SignerUtils.Protocol.valueOf((String)this.getProperty(PROTOCOL_PROPERTY, "https"));
        this.distributionDomain = this.getProperty(DISTRIB_DOMAIN_PROPERTY);
        this.directDownload = Boolean.parseBoolean(this.getProperty("directdownload", Boolean.TRUE.toString()));
        try {
            String privateKeyPath = this.getProperty(PRIVATE_KEY_PROPERTY);
            this.privKey = CloudFrontBinaryManager.loadPrivateKey(privateKeyPath);
            this.privKeyId = this.getProperty(PRIVATE_KEY_ID_PROPERTY);
        }
        catch (InvalidKeySpecException e) {
            throw new IOException(e);
        }
    }

    @Override
    protected URI getRemoteUri(String digest, ManagedBlob blob, HttpServletRequest servletRequest) throws IOException {
        try {
            URIBuilder uriBuilder = new URIBuilder(this.buildResourcePath(this.bucketNamePrefix + digest));
            if (blob != null) {
                uriBuilder.addParameter("response-content-type", this.getContentTypeHeader((Blob)blob));
                uriBuilder.addParameter("response-content-disposition", this.getContentDispositionHeader((Blob)blob, servletRequest));
            }
            if (Framework.isBooleanPropertyTrue((String)ENABLE_CF_ENCODING_FIX)) {
                String trimmedChars = " ";
                uriBuilder.getQueryParams().stream().filter(s -> s.getValue().contains(trimmedChars)).forEach(s -> uriBuilder.setParameter(s.getName(), s.getValue().replace(trimmedChars, "")));
            }
            URI uri = uriBuilder.build();
            if (this.privKey == null) {
                return uri;
            }
            Date expiration = new Date();
            expiration.setTime(expiration.getTime() + (long)(this.directDownloadExpire * 1000));
            String signedURL = CloudFrontUrlSigner.getSignedURLWithCannedPolicy((String)uri.toString(), (String)this.privKeyId, (PrivateKey)this.privKey, (Date)expiration);
            return new URI(signedURL);
        }
        catch (URISyntaxException e) {
            throw new IOException(e);
        }
    }

    private String buildResourcePath(String s3ObjectKey) {
        return this.protocol != SignerUtils.Protocol.http && this.protocol != SignerUtils.Protocol.https ? s3ObjectKey : this.protocol + "://" + this.distributionDomain + "/" + s3ObjectKey;
    }

    private static PrivateKey loadPrivateKey(String privateKeyPath) throws InvalidKeySpecException, IOException {
        if (privateKeyPath == null) {
            return null;
        }
        Throwable throwable = null;
        try (FileInputStream is = new FileInputStream(new File(privateKeyPath));){
            if (privateKeyPath.toLowerCase().endsWith(".pem")) {
                PrivateKey privateKey = PEM.readPrivateKey((InputStream)is);
                return privateKey;
            }
            if (privateKeyPath.toLowerCase().endsWith(".der")) {
                PrivateKey privateKey = RSA.privateKeyFromPKCS8((byte[])IOUtils.toByteArray((InputStream)is));
                return privateKey;
            }
            try {
                throw new AmazonClientException("Unsupported file type for private key");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }
}

