/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.ecm.blob;

import java.util.HashSet;
import java.util.Set;
import org.nuxeo.ecm.core.blob.binary.BinaryGarbageCollector;
import org.nuxeo.ecm.core.blob.binary.BinaryManagerStatus;
import org.nuxeo.ecm.core.blob.binary.CachingBinaryManager;

public abstract class AbstractBinaryGarbageCollector<T extends CachingBinaryManager>
implements BinaryGarbageCollector {
    protected T binaryManager;
    protected BinaryManagerStatus status;
    protected volatile long startTime;
    protected Set<String> marked;

    protected AbstractBinaryGarbageCollector(T binaryManager) {
        this.binaryManager = binaryManager;
    }

    public void start() {
        if (this.startTime != 0L) {
            throw new RuntimeException("Already started");
        }
        this.startTime = System.currentTimeMillis();
        this.status = new BinaryManagerStatus();
        this.marked = new HashSet<String>();
        ((CachingBinaryManager)this.binaryManager).fileCache.clear();
    }

    public void stop(boolean delete) {
        if (this.startTime == 0L) {
            throw new RuntimeException("Not started");
        }
        try {
            Set<String> unmarked = this.getUnmarkedBlobs();
            this.marked = null;
            if (delete) {
                this.binaryManager.removeBinaries(unmarked);
            }
        }
        finally {
            this.status.gcDuration = System.currentTimeMillis() - this.startTime;
            this.startTime = 0L;
        }
    }

    public abstract Set<String> getUnmarkedBlobs();

    public void mark(String digest) {
        this.marked.add(digest);
    }

    public BinaryManagerStatus getStatus() {
        return this.status;
    }

    public boolean isInProgress() {
        return this.startTime != 0L;
    }
}

