/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.io.fsexporter;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.core.io.DocumentReader;
import org.nuxeo.ecm.core.io.DocumentWriter;
import org.nuxeo.ecm.core.io.impl.DocumentPipeImpl;
import org.nuxeo.ecm.core.io.impl.plugins.SingleDocumentReader;
import org.nuxeo.ecm.core.io.impl.plugins.XMLDocumentWriter;
import org.nuxeo.io.fsexporter.DefaultExporterPlugin;

public class CustomExporterPlugin
extends DefaultExporterPlugin {
    @Override
    public File serialize(CoreSession session, DocumentModel docfrom, String fsPath) throws IOException {
        BlobHolder myblobholder = (BlobHolder)docfrom.getAdapter(BlobHolder.class);
        String FileXMLNameToExport = "";
        File folder = new File(fsPath);
        if (myblobholder != null) {
            List listblobs = myblobholder.getBlobs();
            int i = 1;
            for (Blob blob : listblobs) {
                FileXMLNameToExport = this.getFileName(blob, docfrom, folder, i);
                ++i;
            }
            this.exportFileInXML(session, docfrom, fsPath + "/" + FileXMLNameToExport);
        }
        return super.serialize(session, docfrom, fsPath);
    }

    protected void exportFileInXML(CoreSession session, DocumentModel docfrom, String pathtoexport) throws IOException {
        DocumentPipeImpl pipe = new DocumentPipeImpl(10);
        SingleDocumentReader reader = new SingleDocumentReader(session, docfrom);
        pipe.setReader((DocumentReader)reader);
        XMLDocumentWriter writer = new XMLDocumentWriter(new File(pathtoexport + ".xml"));
        pipe.setWriter((DocumentWriter)writer);
        pipe.run();
    }
}

