/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.easyshare;

import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.nuxeo.easyshare.EasyShareUnrestrictedRunner;
import org.nuxeo.ecm.automation.AutomationService;
import org.nuxeo.ecm.automation.OperationContext;
import org.nuxeo.ecm.core.api.Blob;
import org.nuxeo.ecm.core.api.ClientException;
import org.nuxeo.ecm.core.api.CoreSession;
import org.nuxeo.ecm.core.api.DocumentModel;
import org.nuxeo.ecm.core.api.DocumentModelList;
import org.nuxeo.ecm.core.api.DocumentRef;
import org.nuxeo.ecm.core.api.IdRef;
import org.nuxeo.ecm.core.api.blobholder.BlobHolder;
import org.nuxeo.ecm.platform.ec.notification.email.EmailHelper;
import org.nuxeo.ecm.webengine.model.WebObject;
import org.nuxeo.ecm.webengine.model.impl.ModuleRoot;
import org.nuxeo.runtime.api.Framework;

@Path(value="/easyshare")
@Produces(value={"text/html;charset=UTF-8"})
@WebObject(type="EasyShare")
public class EasyShare
extends ModuleRoot {
    protected final Log log = LogFactory.getLog(EasyShare.class);

    @GET
    public Object doGet() {
        return this.getView("index");
    }

    @Path(value="{folderId}")
    @GET
    public Object getFolderListing(@PathParam(value="folderId") String folderId) {
        return new EasyShareUnrestrictedRunner(){

            @Override
            public Object run(CoreSession session, IdRef docRef) throws ClientException {
                if (session.exists((DocumentRef)docRef)) {
                    Date today = new Date();
                    DocumentModel docFolder = session.getDocument((DocumentRef)docRef);
                    if (today.after((Date)docFolder.getProperty("dc:expired").getValue(Date.class))) {
                        return EasyShare.this.getView("denied");
                    }
                    if (!docFolder.getType().equals("EasyShareFolder")) {
                        return Response.serverError().status(Response.Status.NOT_FOUND).build();
                    }
                    DocumentModelList docList = session.getChildren((DocumentRef)docRef);
                    OperationContext ctx = new OperationContext(session);
                    ctx.setInput((Object)docFolder);
                    try {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("event", "Access");
                        params.put("category", "Document");
                        params.put("comment", "IP: " + EasyShare.this.request.getRemoteAddr());
                        AutomationService service = (AutomationService)Framework.getLocalService(AutomationService.class);
                        service.run(ctx, "Audit.Log", params);
                    }
                    catch (Exception ex) {
                        this.log.error((Object)ex.getMessage());
                        return EasyShare.this.getView("denied");
                    }
                    return EasyShare.this.getView("folderList").arg("docFolder", (Object)docFolder).arg("docList", (Object)docList);
                }
                return EasyShare.this.getView("denied");
            }
        }.runUnrestricted(folderId);
    }

    public String getFileName(DocumentModel doc) throws ClientException {
        Blob blob = ((BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob();
        return blob.getFilename();
    }

    @GET
    @Path(value="{folderId}/{fileId}/{fileName}")
    public Response getFileStream(@PathParam(value="fileId") String fileId) throws ClientException {
        return (Response)new EasyShareUnrestrictedRunner(){

            @Override
            public Object run(CoreSession session, IdRef docRef) throws ClientException {
                if (session.exists((DocumentRef)docRef)) {
                    try {
                        DocumentModel doc = session.getDocument((DocumentRef)docRef);
                        Blob blob = ((BlobHolder)doc.getAdapter(BlobHolder.class)).getBlob();
                        DocumentModel docFolder = session.getDocument(doc.getParentRef());
                        OperationContext ctx = new OperationContext(session);
                        ctx.setInput((Object)doc);
                        Date today = new Date();
                        if (today.after((Date)docFolder.getProperty("dc:expired").getValue(Date.class))) {
                            return Response.serverError().status(Response.Status.NOT_FOUND).build();
                        }
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("event", "Download");
                        params.put("category", "Document");
                        params.put("comment", "IP: " + EasyShare.this.request.getRemoteAddr());
                        AutomationService service = (AutomationService)Framework.getLocalService(AutomationService.class);
                        service.run(ctx, "Audit.Log", params);
                        if (doc.isProxy()) {
                            DocumentModel liveDoc = session.getSourceDocument((DocumentRef)docRef);
                            ctx.setInput((Object)liveDoc);
                            service.run(ctx, "Audit.Log", params);
                        }
                        String email = (String)docFolder.getProperty("eshare:contactEmail").getValue(String.class);
                        String fileName = blob.getFilename();
                        String shareName = docFolder.getName();
                        try {
                            this.log.debug((Object)"Easyshare: starting email");
                            EmailHelper emailer = new EmailHelper();
                            Hashtable<String, String> mailProps = new Hashtable<String, String>();
                            mailProps.put("mail.from", "system@nuxeo.com");
                            mailProps.put("mail.to", email);
                            mailProps.put("subject", "EasyShare Download Notification");
                            mailProps.put("body", "File " + fileName + " from " + shareName + " downloaded by " + EasyShare.this.request.getRemoteAddr());
                            mailProps.put("template", "easyShareEmail");
                            emailer.sendmail(mailProps);
                            this.log.debug((Object)"Easyshare: completed email");
                        }
                        catch (Exception ex) {
                            this.log.error((Object)"Cannot send easyShare notification email", (Throwable)ex);
                        }
                        return Response.ok((Object)blob.getStream(), (String)blob.getMimeType()).build();
                    }
                    catch (Exception ex) {
                        this.log.error((Object)"error ", (Throwable)ex);
                        return Response.serverError().status(Response.Status.NOT_FOUND).build();
                    }
                }
                return Response.serverError().status(Response.Status.NOT_FOUND).build();
            }
        }.runUnrestricted(fileId);
    }
}

